import React, { useState } from "react";
import Footer from "../../components/Footer";
import Header from "../../components/Header";

const Contact = () => {
  const [firstName, setFirstName] = useState("");
  const [lastName, setLastName] = useState("");
  const [email, setEmail] = useState("");
  const [phoneNumber, setPhoneNumber] = useState("");
  const [message, setMessage] = useState("");

  const [showError, setShowError] = useState(false);
  const [showSuccess, setShowSuccess] = useState(false);
  const [acceptedTerms, setAcceptedTerms] = useState(false); // ✅ new state

  const handleFormSubmit = (e) => {
    e.preventDefault();

    const formData = {
      firstName: firstName,
      lastName: lastName,
      message: message,
      email: email,
      phoneNumber: phoneNumber,
    };

    fetch("api/sendNewLead", {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify(formData),
    })
      .then((response) => response.json())
      .then((data) => {
        console.log(data);
        setShowSuccess(true);
      })
      .catch((err) => {
        console.log(err);
        setShowError(true);
      });
  };

  return (
    <div>
      <Header />

      <main>
        <div className="contact-form-heading">
          <h2>Contact Us</h2>
          <p>Fill out the form below and we'll be in contact tomorrow.</p>
          <hr className="contact-form-hr" />
        </div>

        <div className="contact-form-container">
          <div className="contact-main-wrapper">
            <div className="contact-form-wrapper">
              <form onSubmit={handleFormSubmit}>
                <div className="contact-input-flex">
                  <div>
                    <label htmlFor="firstname" className="contact-form-label">
                      First name *
                    </label>
                    <input
                      type="text"
                      id="firstname"
                      placeholder="First Name"
                      className="contact-form-input"
                      required
                      value={firstName}
                      onChange={(e) => setFirstName(e.target.value)}
                    />
                  </div>
                  <div>
                    <label htmlFor="lastname" className="contact-form-label">
                      Last name *
                    </label>
                    <input
                      type="text"
                      id="lastname"
                      placeholder="Last Name"
                      className="contact-form-input"
                      required
                      value={lastName}
                      onChange={(e) => setLastName(e.target.value)}
                    />
                  </div>
                </div>

                <div className="contact-input-flex">
                  <div>
                    <label htmlFor="email" className="contact-form-label">
                      Email *
                    </label>
                    <input
                      type="email"
                      id="email"
                      placeholder="example@mail.com"
                      className="contact-form-input"
                      required
                      value={email}
                      onChange={(e) => setEmail(e.target.value)}
                    />
                  </div>
                  <div>
                    <label htmlFor="phone" className="contact-form-label">
                      Phone *
                    </label>
                    <input
                      type="text"
                      id="phone"
                      placeholder="(319) 555-0115"
                      className="contact-form-input"
                      required
                      value={phoneNumber}
                      onChange={(e) => setPhoneNumber(e.target.value)}
                    />
                  </div>
                </div>

                <div>
                  <label htmlFor="message" className="contact-form-label">
                    Message *
                  </label>
                  <textarea
                    rows="6"
                    id="message"
                    placeholder="Type your message"
                    className="contact-form-input"
                    required
                    value={message}
                    onChange={(e) => setMessage(e.target.value)}
                  ></textarea>
                </div>

                {/* Terms and Conditions checkbox */}
                <div
                  className="terms-container"
                  style={{
                    display: "flex",
                    alignItems: "center",
                    marginTop: "16px",
                  }}
                >
                  <input
                    type="checkbox"
                    id="terms"
                    checked={acceptedTerms}
                    onChange={(e) => setAcceptedTerms(e.target.checked)}
                    style={{ marginRight: "8px" }}
                  />
                  <label
                    htmlFor="terms"
                    className="contact-form-label"
                    style={{ margin: 0 }}
                  >
                    I agree to be contacted by Find a Home via call, email, and
                    text. To opt out, you can reply 'stop' at any time or click
                    the unsubscribe link in the emails. Message and data rates
                    may apply. Messages frequency varies{" "}
                    <a
                      href="/privacy"
                      target="_blank"
                      rel="noopener noreferrer"
                      style={{ color: "#007bff", textDecoration: "underline" }}
                    >
                      Terms and Conditions
                    </a>
                  </label>
                </div>

                {showSuccess && (
                  <div className="message-container">
                    <p className="success-message">
                      Your message has sent, we'll be in contact with you
                      shortly!
                    </p>
                  </div>
                )}

                {showError && (
                  <div className="message-container">
                    <p className="error-message">
                      Something has gone wrong with your request, please try
                      again later.
                    </p>
                  </div>
                )}

                <button
                  className="contact-btn text-shadow"
                  type="submit"
                  disabled={!acceptedTerms}
                  style={{
                    opacity: acceptedTerms ? 1 : 0.6,
                    cursor: acceptedTerms ? "pointer" : "not-allowed",
                    marginTop: "16px",
                  }}
                >
                  Send Message
                </button>
              </form>
            </div>
          </div>
        </div>
      </main>

      <Footer />
    </div>
  );
};

export default Contact;
