import React, { useState } from "react";
import "./style.css";
import Footer from "../../../components/Footer";
import Header from "../../../components/Header";
import PricingGrid from "./grid";
import PricingCards from "./cards";
import Modal from "./modal";

const AgentSignup1 = () => {
  const [modalOpen, setModalOpen] = useState(false);

  const handleFree = () => {
    localStorage.removeItem("plan_type");
    window.location.href = "/agent-signup";
  };
  // const handleStandard = () => {
  //   localStorage.setItem("plan_type", "Standard");
  //   window.location.href = "/agent-signup";
  // };
  // const handlePro = () => {
  //   localStorage.setItem("plan_type", "Pro");
  //   window.location.href = "/agent-signup";
  // };
  // const handleEnterprise = () => {
  //   setModalOpen(true);
  // };

  return (
    <div>
      <Header />

      <div className="pricing-header">
        <h1>Find a Home Agent Services</h1>

        <h2>
          Create your Realtor profile to become part of the "Find A Home,"
          community
        </h2>

        <p>
          Whether you're a solo agent or a growing real estate team, our
          networking tools are designed to build your brand, help you generate
          more business, and build lasting relationships. There is no charge to
          create your profile. You will become visible as available agents in
          the areas that you select. As an added bonus, you will gain free
          membership to the Busca Marketing Center. You'll have the tools you
          need to create postcard campaigns, direct mailers listing flyers, and
          toolkits in English and Spanish.
        </p>
      </div>

      <main className="pricing-main">
        {/* Desktop View*/}
        <PricingGrid handleFree={handleFree} />

        {/* Mobile View */}
        <PricingCards handleFree={handleFree} />
      </main>

      <div className="pricing-footer">
        <p>Your Network, Your Deals, Your Success—All in One Platform.</p>
      </div>

      <Footer />

      {modalOpen ? <Modal setModalOpen={setModalOpen} /> : <></>}
    </div>
  );
};

export default AgentSignup1;
