// import React, { useState, useEffect } from "react";
// import ReactPaginate from "react-paginate";
// import Footer from "../../../components/Footer";
// import Header from "../../../components/Header";
// import AgentImage from "../../../assets/agent-search.jpg";
// import AgentCard from "../../../components/AgentResultCard";
// import {
//   getAgentByCity,
//   getAgentByCityAndName,
//   getAgentByName,
//   getAgentNames,
//   getPremiumAgents,
//   getAgentFullNames,
//   getAgentByCityAndFullName,
// } from "../../../utils/api";
// import PlacesAutocomplete from "../../../components/PlacesAutocomplete";

// const AgentSearch = () => {
//   const [agents, setAgents] = useState([]);
//   const [isFeatured, setIsFeatured] = useState(false);
//   const [isLoading, setLoading] = useState(false);

//   const premiumAgentsFirst = (data) => {
//     const premiumAgents = data.filter((agent) => agent.isPremium === true);
//     const notpremiumAgents = data.filter((agent) => agent.isPremium === false);

//     const complete = premiumAgents.concat(notpremiumAgents);
//     return complete;
//   };

//   // Pagination
//   const itemsPerPage = 9;
//   // We start with an empty list of items.
//   const [currentItems, setCurrentItems] = useState(null);
//   const [pageCount, setPageCount] = useState(0);
//   // Here we use item offsets; we could also use page offsets
//   // following the API or data you're working with.
//   const [itemOffset, setItemOffset] = useState(0);

//   useEffect(() => {
//     // Fetch items from another resources.
//     const endOffset = itemOffset + itemsPerPage;
//     // console.log(`Loading items from ${itemOffset} to ${endOffset}`);
//     setCurrentItems(agents.slice(itemOffset, endOffset));
//     // console.log(agents.slice(itemOffset, endOffset));
//     setPageCount(Math.ceil(agents.length / itemsPerPage));
//   }, [itemOffset, itemsPerPage, agents]);

//   // Invoke when user click to request another page.
//   const handlePageClick = (event) => {
//     const newOffset = (event.selected * itemsPerPage) % agents.length;
//     // console.log(
//     //   `User requested page number ${event.selected}, which is offset ${newOffset}`
//     // );
//     setItemOffset(newOffset);
//   };

//   // Search Input
//   const [selectedName, setselectedName] = useState("");
//   const [formattedAddress, setFormattedAddress] = React.useState("");
//   const [showNameDropdown, setShowNameDropdown] = useState(false);
//   const [names, setNames] = useState([]);
//   const [filteredNames, setfilteredNames] = useState([]);
//   const [isFullName, setIsFullName] = useState(false);

//   /** Name Input Functions */
//   // Remove the Drop-down when a user selects on an option
//   const handleNameInputSelect = (name) => {
//     setselectedName(name);
//     setNames([]);
//     setfilteredNames([]);
//     setShowNameDropdown(false);
//     setIsFullName(true);
//   };
//   const filterName = (selectedName) => {
//     const filtered = names.filter((name) =>
//       name.toLowerCase().startsWith(selectedName.toLowerCase())
//     );
//     setfilteredNames(filtered);
//   };
//   // Triggered when the user types in the Input field
//   const handleNameInputChange = (event) => {
//     const selectedName = event.target.value;
//     setselectedName(selectedName);
//     localStorage.removeItem("agentSearchTerm");
//     setIsFullName(false);
//     if (selectedName.trim() === "") {
//       setShowNameDropdown(false);
//       setNames([]);
//     } else if (selectedName.length === 1) {
//       // Fetch Name Names from db
//       getAgentNames(selectedName.trim())
//         .then((res) => res.json())
//         .then((data) => {
//           // console.log(data);

//           setNames(data);
//           setfilteredNames(data);
//           setShowNameDropdown(true);
//         })
//         .catch((err) => console.log(err));
//     } else if (selectedName.length > 1) {
//       filterName(selectedName);
//     }
//   };

//   // Handle Autcomplete options based on key input
//   const handleNameKeyDown = (e) => {
//     const action = e.keyCode;

//     switch (action) {
//       case 40:
//         // Down arrow (Scroll down)
//         if (!selectedName) {
//           setselectedName(filteredNames[0]);
//         } else {
//           const index = filteredNames.indexOf(selectedName);
//           const increment = index + 1;
//           return !filteredNames[increment]
//             ? null
//             : setselectedName(filteredNames[increment]);
//         }
//         break;
//       case 38:
//         // Up arrow (Scroll up)
//         if (!selectedName) {
//           return;
//         } else {
//           const index = filteredNames.indexOf(selectedName);
//           const decrimate = index - 1;
//           return !filteredNames[decrimate]
//             ? setselectedName("")
//             : setselectedName(filteredNames[decrimate]);
//         }
//       case 13:
//         // Return (Select)
//         setselectedName(selectedName);
//         setNames([]);
//         setfilteredNames([]);
//         setIsFullName(true);
//         break;
//       default:
//         return;
//     }
//   };

//   const handleSearch = (e) => {
//     e.preventDefault();

//     let x = 0;
//     if (formattedAddress.trim() !== "") {
//       x = x + 1;
//     }
//     if (selectedName.trim() !== "") {
//       x = x + 2;
//     }

//     switch (x) {
//       case 0:
//         break;
//       case 1:
//         // Search by City
//         getAgentByCity(formattedAddress.trim())
//           .then((res) => res.json())
//           .then((data) => {
//             // console.log(data);
//             const premiumFirst = premiumAgentsFirst(data.filterCities);
//             setAgents(premiumFirst);
//             setIsFeatured(false);
//           })
//           .catch((err) => console.log(err));
//         break;
//       case 2:
//         // Search by Name
//         if (isFullName === true) {
//           getAgentFullNames(selectedName.trim())
//             .then((res) => res.json())
//             .then((data) => {
//               // console.log(data);
//               const premiumFirst = premiumAgentsFirst(data);
//               setAgents(premiumFirst);
//               setIsFeatured(false);
//             })
//             .catch((err) => console.log(err));
//         } else {
//           getAgentByName(selectedName.trim())
//             .then((res) => res.json())
//             .then((data) => {
//               // console.log(data);
//               const premiumFirst = premiumAgentsFirst(data);
//               setAgents(premiumFirst);
//               setIsFeatured(false);
//             })
//             .catch((err) => console.log(err));
//         }
//         break;
//       case 3:
//         // Search by City and Name
//         if (isFullName === true) {
//           getAgentByCityAndFullName(
//             formattedAddress.trim(),
//             selectedName.trim()
//           )
//             .then((res) => res.json())
//             .then((data) => {
//               // console.log(data);
//               const premiumFirst = premiumAgentsFirst(data.filterCities);
//               setAgents(premiumFirst);
//               setIsFeatured(false);
//             })
//             .catch((err) => console.log(err));
//         } else {
//           getAgentByCityAndName(formattedAddress.trim(), selectedName.trim())
//             .then((res) => res.json())
//             .then((data) => {
//               // console.log(data);
//               const premiumFirst = premiumAgentsFirst(data.filterCities);
//               setAgents(premiumFirst);
//               setIsFeatured(false);
//             })
//             .catch((err) => console.log(err));
//         }

//         break;
//       default:
//         break;
//     }
//   };

//   useEffect(() => {
//     // Get Premium Agents on page load
//     getPremiumAgents()
//       .then((res) => res.json())
//       .then((data) => {
//         // console.log(data);

//         setAgents(data);
//         setIsFeatured(true);
//         setLoading(false);
//       })
//       .catch((err) => console.log(err));
//   }, []);

//   if (isLoading) {
//     return (
//       <>
//         <Header />

//         <div className="min-height"></div>
//         <Footer />
//       </>
//     );
//   }

//   return (
//     <div>
//       <Header />

//       {/* Page Header/Searchbar */}
//       <div className="agent-search-header">
//         <img
//           className="agent-search-image"
//           src={AgentImage}
//           alt="A welcoming front porch with chaires and a plant."
//         />
//         <div className="agent-search-header-bg">
//           <h1>Find An Agent In Your Area</h1>

//           <div className="agent-search-form">
//             <div className="input-container">
//               <div>
//                 <PlacesAutocomplete
//                   setFormattedAddress={setFormattedAddress}
//                   formattedAddress={formattedAddress}
//                 />
//               </div>
//             </div>
//             <label htmlFor="city" className="hidden">
//               City
//             </label>
//             <div className="input-container">
//               <input
//                 className="agent-search-input"
//                 type="text"
//                 id="name"
//                 name="name"
//                 placeholder="Name"
//                 value={selectedName}
//                 onChange={handleNameInputChange}
//                 onKeyDown={(e) => {
//                   handleNameKeyDown(e);
//                 }}
//                 autoComplete="off"
//               />
//               {showNameDropdown && (
//                 <div className="dropdown-items">
//                   {filteredNames.map((name) => (
//                     <div
//                       key={name}
//                       className={
//                         name === selectedName
//                           ? "dropdown-item highlight"
//                           : "dropdown-item"
//                       }
//                       onClick={() => handleNameInputSelect(name)}
//                     >
//                       <p>{name}</p>
//                     </div>
//                   ))}
//                 </div>
//               )}
//             </div>
//             <label htmlFor="name" className="hidden">
//               Name
//             </label>
//             <button
//               className="agent-search-btn text-shadow"
//               onClick={handleSearch}
//             >
//               Search Now
//             </button>
//           </div>
//         </div>
//       </div>

//       <main className="agent-search-results">
//         <h2>
//           {/* <b>
//             {agents.length} {isFeatured === true ? "Featured" : ""}
//           </b>{" "} */}
//           Featured Agents
//         </h2>

//         {/* Result Containr */}
//         <Items currentItems={currentItems} />

//         {/* Pagination Buttons */}
//         <div className="pagination-container">
//           <ReactPaginate
//             nextLabel="next >"
//             onPageChange={handlePageClick}
//             pageRangeDisplayed={3}
//             marginPagesDisplayed={2}
//             pageCount={pageCount}
//             previousLabel="< previous"
//             pageClassName="page-item"
//             pageLinkClassName="page-link"
//             previousClassName="page-item"
//             previousLinkClassName="page-link"
//             nextClassName="page-item"
//             nextLinkClassName="page-link"
//             breakLabel="..."
//             breakClassName="page-item"
//             breakLinkClassName="page-link"
//             containerClassName="pagination"
//             activeClassName="active"
//             renderOnZeroPageCount={null}
//           />
//         </div>
//       </main>

//       <Footer />
//     </div>
//   );
// };

// const Items = ({ currentItems }) => {
//   return (
//     <div className="agent-search-results-container">
//       {currentItems !== null &&
//         currentItems.map((item) => <AgentCard key={item.id} agent={item} />)}
//     </div>
//   );
// };

// export default AgentSearch;

import React, { useState, useEffect } from "react";
import ReactPaginate from "react-paginate";
import Footer from "../../../components/Footer";
import Header from "../../../components/Header";
import AgentImage from "../../../assets/agent-search.jpg";
import AgentCard from "../../../components/AgentResultCard";
import {
  getAgentByCity,
  getAgentByCityAndName,
  getAgentByName,
  getAgentNames,
  getPremiumAgents,
  getAgentFullNames,
  getAgentByCityAndFullName,
} from "../../../utils/api";
import PlacesAutocomplete from "../../../components/PlacesAutocomplete";
import { useSearchParams, useNavigate } from "react-router-dom";

const AgentSearch = () => {
  const [searchParams, setSearchParams] = useSearchParams();
  const navigate = useNavigate();

  const [agents, setAgents] = useState([]);
  const [isFeatured, setIsFeatured] = useState(false);
  const [isLoading, setLoading] = useState(false);

  const premiumAgentsFirst = (data) => {
    const premiumAgents = data.filter((agent) => agent.isPremium === true);
    const notpremiumAgents = data.filter((agent) => agent.isPremium === false);
    return premiumAgents.concat(notpremiumAgents);
  };

  const itemsPerPage = 9;
  const [currentItems, setCurrentItems] = useState(null);
  const [pageCount, setPageCount] = useState(0);
  const [itemOffset, setItemOffset] = useState(0);

  useEffect(() => {
    const endOffset = itemOffset + itemsPerPage;
    setCurrentItems(agents.slice(itemOffset, endOffset));
    setPageCount(Math.ceil(agents.length / itemsPerPage));
  }, [itemOffset, itemsPerPage, agents]);

  const handlePageClick = (event) => {
    const newOffset = (event.selected * itemsPerPage) % agents.length;
    setItemOffset(newOffset);
  };

  const [selectedName, setselectedName] = useState("");
  const [formattedAddress, setFormattedAddress] = useState("");
  const [showNameDropdown, setShowNameDropdown] = useState(false);
  const [names, setNames] = useState([]);
  const [filteredNames, setfilteredNames] = useState([]);
  const [isFullName, setIsFullName] = useState(false);

  const handleNameInputSelect = (name) => {
    setselectedName(name);
    setNames([]);
    setfilteredNames([]);
    setShowNameDropdown(false);
    setIsFullName(true);
  };

  const filterName = (selectedName) => {
    const filtered = names.filter((name) =>
      name.toLowerCase().startsWith(selectedName.toLowerCase())
    );
    setfilteredNames(filtered);
  };

  const handleNameInputChange = (event) => {
    const selectedName = event.target.value;
    setselectedName(selectedName);
    localStorage.removeItem("agentSearchTerm");
    setIsFullName(false);
    if (selectedName.trim() === "") {
      setShowNameDropdown(false);
      setNames([]);
    } else if (selectedName.length === 1) {
      getAgentNames(selectedName.trim())
        .then((res) => res.json())
        .then((data) => {
          setNames(data);
          setfilteredNames(data);
          setShowNameDropdown(true);
        })
        .catch((err) => console.log(err));
    } else if (selectedName.length > 1) {
      filterName(selectedName);
    }
  };

  const handleNameKeyDown = (e) => {
    const action = e.keyCode;
    switch (action) {
      case 40:
        if (!selectedName) {
          setselectedName(filteredNames[0]);
        } else {
          const index = filteredNames.indexOf(selectedName);
          const increment = index + 1;
          if (filteredNames[increment])
            setselectedName(filteredNames[increment]);
        }
        break;
      case 38:
        if (!selectedName) return;
        const index = filteredNames.indexOf(selectedName);
        const decrement = index - 1;
        setselectedName(filteredNames[decrement] || "");
        break;
      case 13:
        setselectedName(selectedName);
        setNames([]);
        setfilteredNames([]);
        setIsFullName(true);
        break;
      default:
        return;
    }
  };

  const searchAgents = (city, name, fullNameCheck = false) => {
    let x = 0;
    if (city.trim() !== "") x += 1;
    if (name.trim() !== "") x += 2;

    switch (x) {
      case 1:
        getAgentByCity(city.trim())
          .then((res) => res.json())
          .then((data) => {
            const premiumFirst = premiumAgentsFirst(data.filterCities);
            setAgents(premiumFirst);
            setIsFeatured(false);
          });
        break;
      case 2:
        if (fullNameCheck) {
          getAgentFullNames(name.trim())
            .then((res) => res.json())
            .then((data) => {
              const premiumFirst = premiumAgentsFirst(data);
              setAgents(premiumFirst);
              setIsFeatured(false);
            });
        } else {
          getAgentByName(name.trim())
            .then((res) => res.json())
            .then((data) => {
              const premiumFirst = premiumAgentsFirst(data);
              setAgents(premiumFirst);
              setIsFeatured(false);
            });
        }
        break;
      case 3:
        if (fullNameCheck) {
          getAgentByCityAndFullName(city.trim(), name.trim())
            .then((res) => res.json())
            .then((data) => {
              const premiumFirst = premiumAgentsFirst(data.filterCities);
              setAgents(premiumFirst);
              setIsFeatured(false);
            });
        } else {
          getAgentByCityAndName(city.trim(), name.trim())
            .then((res) => res.json())
            .then((data) => {
              const premiumFirst = premiumAgentsFirst(data.filterCities);
              setAgents(premiumFirst);
              setIsFeatured(false);
            });
        }
        break;
      default:
        break;
    }
  };

  const handleSearch = (e) => {
    e.preventDefault();
    const city = formattedAddress.trim();
    const name = selectedName.trim();

    const params = {};
    if (city) params.city = city;
    if (name) params.name = name;
    setSearchParams(params);

    searchAgents(city, name, isFullName);
  };

  useEffect(() => {
    const cityFromURL = searchParams.get("city") || "";
    const nameFromURL = searchParams.get("name") || "";

    if (cityFromURL || nameFromURL) {
      setFormattedAddress(cityFromURL);
      setselectedName(nameFromURL);
      const isFull = nameFromURL.split(" ").length > 1;
      setIsFullName(isFull);
      searchAgents(cityFromURL, nameFromURL, isFull);
    } else {
      getPremiumAgents()
        .then((res) => res.json())
        .then((data) => {
          setAgents(data);
          setIsFeatured(true);
          setLoading(false);
        })
        .catch((err) => console.log(err));
    }
  }, []);

  if (isLoading) {
    return (
      <>
        <Header />
        <div className="min-height"></div>
        <Footer />
      </>
    );
  }

  return (
    <div>
      <Header />
      <div className="agent-search-header">
        <img
          className="agent-search-image"
          src={AgentImage}
          alt="Agent banner"
        />
        <div className="agent-search-header-bg">
          <h1>Find An Agent In Your Area</h1>
          <div className="agent-search-form">
            <div className="input-container">
              <PlacesAutocomplete
                setFormattedAddress={setFormattedAddress}
                formattedAddress={formattedAddress}
              />
            </div>
            <div className="input-container">
              <input
                className="agent-search-input"
                type="text"
                placeholder="Name"
                value={selectedName}
                onChange={handleNameInputChange}
                onKeyDown={handleNameKeyDown}
                autoComplete="off"
              />
              {showNameDropdown && (
                <div className="dropdown-items">
                  {filteredNames.map((name) => (
                    <div
                      key={name}
                      className={
                        name === selectedName
                          ? "dropdown-item highlight"
                          : "dropdown-item"
                      }
                      onClick={() => handleNameInputSelect(name)}
                    >
                      <p>{name}</p>
                    </div>
                  ))}
                </div>
              )}
            </div>
            <button
              className="agent-search-btn text-shadow"
              onClick={handleSearch}
            >
              Search Now
            </button>
          </div>
        </div>
      </div>

      <main className="agent-search-results">
        <h2>Featured Agents</h2>
        <Items currentItems={currentItems} />
        <div className="pagination-container">
          <ReactPaginate
            nextLabel="next >"
            onPageChange={handlePageClick}
            pageRangeDisplayed={3}
            marginPagesDisplayed={2}
            pageCount={pageCount}
            previousLabel="< previous"
            pageClassName="page-item"
            pageLinkClassName="page-link"
            previousClassName="page-item"
            previousLinkClassName="page-link"
            nextClassName="page-item"
            nextLinkClassName="page-link"
            breakLabel="..."
            breakClassName="page-item"
            breakLinkClassName="page-link"
            containerClassName="pagination"
            activeClassName="active"
            renderOnZeroPageCount={null}
          />
        </div>
      </main>
      <Footer />
    </div>
  );
};

const Items = ({ currentItems }) => {
  return (
    <div className="agent-search-results-container">
      {currentItems &&
        currentItems.map((item) => <AgentCard key={item.id} agent={item} />)}
    </div>
  );
};

export default AgentSearch;
