import React, { useState, useEffect } from "react";
import EditProfile from "./edit-profile";
import Dashboard from "./dashboard";
import headerImg from "../../../assets/3-1.png";
import Auth from "../../../utils/auth";
import { useNavigate } from "react-router-dom";
import { getUserProfile } from "../../../utils/api";

const Portal = () => {
  const navigate = useNavigate();
  const [isLoading, setLoading] = useState(true);

  const [isOpen, setIsOpen] = useState(false);
  const [currentPage, setCurrentPage] = useState("Dashboard");
  const [user, setUser] = useState("");
  const [agent, setAgent] = useState("");

  // Run Query Once
  useEffect(() => {
    // User token
    let currentUser;
    if (Auth.loggedIn() !== false) {
      currentUser = Auth.getUser();

      getUserProfile(currentUser.id)
        .then((res) => res.json())
        .then((data) => {
          console.log(data);
          // Set the from states with db data
          setUser({
            id: data.id,
            name: data.name,
            email: data.email,
          });
          setAgent(data.lenders[0]);

          setLoading(false);
        })
        .catch((err) => console.log(err));
    } else {
      navigate(`/user-login`);
    }
  }, []);

  const getCurrentPage = () => {
    switch (currentPage) {
      case "Dashboard":
        return (
          <Dashboard
            setCurrentPage={setCurrentPage}
            user={user}
            agent={agent}
          />
        );
      case "Edit Profile":
        return (
          <EditProfile
            setCurrentPage={setCurrentPage}
            user={user}
            agent={agent}
          />
        );
      default:
        return (
          <Dashboard
            setCurrentPage={setCurrentPage}
            user={user}
            agent={agent}
          />
        );
    }
  };

  if (isLoading) {
    return <>loading...</>;
  }

  return (
    <div className="agent-portal">
      <header>
        <div onClick={() => setCurrentPage("Dashboard")}>
          <img
            className="agent-portal-logo"
            alt="Find A Home Logo"
            src={headerImg}
          />
        </div>

        <div
          className={isOpen === false ? "" : "nav-open"}
          onClick={() => {
            setIsOpen(!isOpen);
          }}
        >
          <p>
            {agent.first_name} {agent.last_name}
          </p>
          <div
            className={
              isOpen === false ? "agent-portal-menu" : "agent-portal-menu open"
            }
          >
            <ul>
              <li onClick={() => Auth.logout()}>Logout</li>
            </ul>
          </div>
        </div>
      </header>

      {/* Main */}
      <main>{getCurrentPage()}</main>
    </div>
  );
};

export default Portal;
