const express = require("express");
const fileUpload = require("express-fileupload");
const path = require("path");
const routes = require("./routes");
const sequelize = require("./config/connection");
const cors = require("cors");

// App setup
const app = express();
const PORT = process.env.PORT || 3000;

app.use(
  cors({
    origin: ["http://localhost:3000", "http://localhost:3001"],
    credentials: true,
  })
);
app.options("*", cors());

// App Middleware
app.use(express.json());
app.use(express.static(path.join(__dirname, "../uploads")));
app.use(express.urlencoded({ extended: true }));
app.use(fileUpload());
app.use(routes);

//dummy comment

// *** Uncomment to serve the Ruuster React Application wildcard route ***
app.use(express.static("../client/ruuster/build/"));
app.get("*", (req, res) => {
  res.sendFile(path.resolve(__dirname, "../client/ruuster/build/index.html"));
});

// Connect Database and Server
// {force: false}: Database will not recreate tables if associations change
sequelize.sync({ force: false }).then(() => {
  app.listen(PORT, () => {
    console.log(`Server is running on PORT: ${PORT}`);
  });
});
