const { Model, DataTypes } = require("sequelize");

const sequelize = require("../config/connection.js");

class Agent extends Model {}

Agent.init(
  {
    // define columns
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    full_name: {
      type: DataTypes.STRING,
      allowNull: true,
      get() {
        const firstName = this.getDataValue("first_name");
        const lastName = this.getDataValue("last_name");
        return firstName && lastName ? `${firstName} ${lastName}` : null;
      },
    },
    first_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    last_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    phone_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING,
      unique: false,
      allowNull: true,
    },
    languages_spoken: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    primary_language: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: "English",
    },
    brokerage: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    brokerage_number: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: "",
    },
    areas_served: {
      type: DataTypes.STRING(1500),
      allowNull: true,
      defaultValue: "",
    },
    state_license_numbers: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    profile_description: {
      type: DataTypes.STRING(1500),
      allowNull: true,
    },
    image: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    isPremium: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    iframe_link: {
      type: DataTypes.TEXT,
      allowNull: true,
      defaultValue: null,
    },
    plan_type: {
      type: DataTypes.TEXT,
      allowNull: true,
      defaultValue: "Free",
    },
    // Store a reference of user model's id
    user_id: {
      type: DataTypes.INTEGER,
      references: {
        model: "user",
        key: "id",
      },
    },
    isDeleted: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    // isVerified: {
    //   type: DataTypes.BOOLEAN,
    //   defaultValue: false,
    // },
  },
  {
    sequelize,
    timestamps: false,
    freezeTableName: true,
    underscored: true,
    modelName: "agent",
  }
);

module.exports = Agent;

// Primary Language selects which website the user will display on
// English - Findahome.com
// Spanish - Buscatucasa.com
// Both - will display on both sites
