const { Model, DataTypes } = require("sequelize");

const sequelize = require("../config/connection");
const { formatDate } = require("../utils/formatDate.js");

class Uploads extends Model {}

Uploads.init(
  {
    // define columns
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    location: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    display_name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    type: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    date: {
      type: DataTypes.DATE,
      defaultValue: new Date(),
      allowNull: false,
      get() {
        return formatDate(this.getDataValue("date"));
      },
    },
    agent_id: {
      type: DataTypes.INTEGER,
      references: {
        model: "agent",
        key: "id",
      },
    },
    isDeleted: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
  },
  {
    sequelize,
    timestamps: false,
    freezeTableName: true,
    underscored: true,
    modelName: "uploads",
  }
);

module.exports = Uploads;
