// import models
const Agent = require("./Agent");
const User = require("./User");
const Uploads = require("./Uploads");
const Notices = require("./Notices");
const PasswordReset = require("./PasswordReset");
const Lender = require("./Lender");

// Uploads belongs to Agent
Uploads.belongsTo(Agent, {
  foreignKey: "agent_id",
});

Agent.hasMany(Uploads, {
  foreignKey: "agent_id",
});

// Agent belongs to User
Agent.belongsTo(User, {
  foreignKey: "user_id",
});

User.hasMany(Agent, {
  foreignKey: "user_id",
});

// Password Reset
User.hasOne(PasswordReset, {
  foreignKey: "user_id",
  onDelete: "CASCADE",
});

PasswordReset.belongsTo(User, {
  foreignKey: "user_id",
  onDelete: "CASCADE",
});

// Lender belongs to User
Lender.belongsTo(User, {
  foreignKey: "user_id",
});

User.hasMany(Lender, {
  foreignKey: "user_id",
});

// Uploads belongs to Lender
Uploads.belongsTo(Lender, {
  foreignKey: "lender_id",
});

Lender.hasMany(Uploads, {
  foreignKey: "lender_id",
});

module.exports = {
  Agent,
  User,
  Uploads,
  Notices,
  PasswordReset,
  Lender,
};
