// const router = require("express").Router();
// const AppError = require("../../utils/appError");
// const nodemailer = require("nodemailer");

// // Welcome Email
// router.post("/send-welcome-email", async (req, res, next) => {
//   if (!req.body || !req.body.email) {
//     return next(new AppError("Email address is required", 400));
//   }

//   try {
//     // set up nodemailer transporter
//     const transporter = nodemailer.createTransport({
//       service: "gmail",
//       port: 465,
//       auth: {
//         user: "help@brainjar.net",
//         pass: "voeujiyymzlthwdc",
//         // user: "huzuhuzair@gmail.com",
//         // pass: "tgvk qdnv csex skwh",
//       },
//     });

//     console.log("using Port 465");

//     // mail options
//     const mailOptions = {
//       from: "camila@buscatucasa.com",
//       to: req.body.email,
//       subject: "Welcome Findahome Agent!",
//       //we can style this
//       text: `Welcome to the Findahome Agent network! We're happy to have you.`,
//     };

//     // send email
//     transporter.sendMail(mailOptions, (error, info) => {
//       console.log("====", error);
//       if (error) {
//         return next(
//           new AppError(
//             "Error sending email from Findahome.com on port 465: " +
//               error.message,
//             500
//           )
//         );
//       } else {
//         res.json({
//           message: "Your welcome email has been sent to the email address.",
//         });
//       }
//     });
//   } catch (err) {
//     console.error("Error:", err);
//     return next(new AppError("Server error: " + err.message, 500));
//   }
// });

// // Confirmation Email (To Jason)
// router.post("/send-confirmation-email", async (req, res, next) => {
//   try {
//     // set up nodemailer transporter
//     const transporter = nodemailer.createTransport({
//       service: "gmail",
//       port: 465,
//       auth: {
//         user: "help@brainjar.net",
//         pass: "voeujiyymzlthwdc",
//         // user: "huzuhuzair@gmail.com",
//         // pass: "tgvk qdnv csex skwh",
//       },
//     });

//     // mail options
//     const mailOptions = {
//       from: "no-reply@buscatucasa.com",
//       to: "camila@buscatucasa.com",
//       subject: "New Agent Signup",
//       //we can style this
//       text: `A new Find a Home Agent has signed up!`,
//     };

//     // send email
//     transporter.sendMail(mailOptions, (error, info) => {
//       if (error) {
//         return next(new AppError("Error sending email: " + error.message, 500));
//       } else {
//         res.json({
//           message: "Your confirmation email has been sent.",
//         });
//       }
//     });
//   } catch (err) {
//     console.error("Error:", err);
//     return next(new AppError("Server error: " + err.message, 500));
//   }
// });
// router.get("/version-check", (req, res) => {
//   res.json({
//     deployed: true,
//     version: "v3.0",
//     timestamp: new Date().toISOString(),
//     note: "âœ… Deployed and working on findahome.com",
//   });
// });

// module.exports = router;
// Polyfills for Node.js (fix Headers and Blob not defined errors)
// 🌐 Polyfill Web APIs required by googleapis/gaxios
// 🌐 Polyfill Web APIs required by googleapis/gaxios

// 📦 Imports
const { google } = require("googleapis");
const router = require("express").Router();
const AppError = require("../../utils/appError");
const nodemailer = require("nodemailer");
const fs = require("fs");

// Logger for email results
const log = (msg) => {
  fs.appendFileSync(
    "/home/findahom/public_html/findahom-app/email-log.txt",
    `[${new Date().toISOString()}] ${msg}\n`
  );
};

// OAuth credentials
const config = {
  welcome: {
    clientId: "934855484633-ih87parq4nij3to50mvmr8matnbqk1v0.apps.googleusercontent.com",
    clientSecret: "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",
    redirectUri: "https://developers.google.com/oauthplayground",
    refreshToken: "1//04hUZZT_hE8z7CgYIARAAGAQSNwF-L9IrtKqOg1ROl8Cplb3Tjp8EI1dhJ5-ndc0_nPIJGvlsOm4BBU822bHNS4NzosgrIAu7cmw",
    senderEmail: "camila@buscatucasa.com",
  },
  confirm: {
    clientId: "751506196930-si65vo7gaeph16lamvj95j8k1sdelinj.apps.googleusercontent.com",
    clientSecret: "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",
    redirectUri: "https://developers.google.com/oauthplayground",
    refreshToken: "1//041jOjt5SKZArCgYIARAAGAQSNwF-L9IrRLT-yA4W3ncg03JMVOOJUEKQojI1cCPSxPJzjDMjJTbRxOpDDdUTXpfiQm1PFAmQAOM",
    senderEmail: "help@brainjar.net",
  },
};

// Create Nodemailer transporter using OAuth2
const createTransporter = async ({ clientId, clientSecret, redirectUri, refreshToken, senderEmail }) => {
  const oAuth2Client = new google.auth.OAuth2(clientId, clientSecret, redirectUri);
  oAuth2Client.setCredentials({ refresh_token: refreshToken });

  const accessToken = await oAuth2Client.getAccessToken();

  return nodemailer.createTransport({
    service: "gmail",
    auth: {
      type: "OAuth2",
      user: senderEmail,
      clientId,
      clientSecret,
      refreshToken,
      accessToken: accessToken.token,
    },
  });
};

// Welcome email endpoint
router.post("/send-welcome-email", async (req, res, next) => {
  if (!req.body?.email) return next(new AppError("Email address is required", 400));

  try {
    const transporter = await createTransporter(config.welcome);
    await transporter.sendMail({
      from: `<${config.welcome.senderEmail}>`,
      to: req.body.email,
      subject: "🎉 Welcome to Findahome Agent Network!",
      html: `
        <div style="font-family: Arial, sans-serif; padding: 20px; background-color: #f8f9fa; color: #333;">
          <h2 style="color: #007bff;">Welcome to the Findahome Agent Network!</h2>
          <p>Hi there,</p>
          <p>
            We're excited to welcome you to the <strong>Findahome Agent</strong> community.
            As a member of our trusted network, you'll gain access to exclusive tools, listings, and support.
          </p>
          <p>If you have any questions or need help getting started, feel free to reach out at any time.</p>
          <p style="margin-top: 30px;">🔗 <a href="https://findahome.com" style="color: #007bff;">Visit your dashboard</a></p>
          <hr style="margin-top: 40px;">
          <p style="font-size: 12px; color: #888;">
            You are receiving this email because you signed up as an agent on Findahome.<br>
            If you did not initiate this registration, please ignore this message.
          </p>
        </div>
      `,
    });

    log(`✅ Welcome email sent to ${req.body.email}`);
    res.json({ message: "✅ Welcome email sent successfully." });
  } catch (err) {
    log(`❌ Welcome email failed: ${err.message}`);
    console.error("OAuth Email Error (Welcome):", err);
    return next(new AppError("Email sending error: " + err.message, 500));
  }
});

// Confirmation email endpoint
router.post("/send-confirmation-email", async (req, res, next) => {
  try {
    const transporter = await createTransporter(config.confirm);
    await transporter.sendMail({
      from: `<${config.confirm.senderEmail}>`,
      to: "camila@buscatucasa.com",
      subject: "New Agent Signup",
      text: "A new Find a Home Agent has signed up!",
    });

    log("✅ Confirmation email sent to camila@buscatucasa.com");
    res.json({ message: "✅ Confirmation email sent successfully." });
  } catch (err) {
    log(`❌ Confirmation email failed: ${err.message}`);
    console.error("OAuth Email Error (Confirmation):", err);
    return next(new AppError("Email sending error: " + err.message, 500));
  }
});

// Version check
router.get("/version-check", (req, res) => {
  res.json({
    deployed: true,
    version: "v8.0",
    timestamp: new Date().toISOString(),
    note: "✅ Deployed and working on findahomeinusa.com",
  });
});

module.exports = router;
