const router = require("express").Router();
const { Lender, Uploads, Notices, User } = require("../../models");
const { Op } = require("sequelize");
const { cityStartsWith } = require("../utils/agentHelpers");

// The `/api/lenders` endpoint

/*
  Currently Unused
*/
router.get("/", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
    },
  })
    .then((allOficers) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allOficers.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Recently Added Lenders
*/
router.get("/recently-added", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
    },
    limit: 50,
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Premium Lenders
*/
router.get("/premium", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      isPremium: true,
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by City
*/
router.get("/city/:term", (req, res) => {
  console.log("Searching for lenders in city:", req.params.term);
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      const filtered = cityStartsWith(allLenders, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by City (Search Bar)
*/
router.get("/city-searchbar/:term", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      const filtered = cityStartsWith(allLenders, req.params.term);

      res.json(filtered.uniqueCities);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Name (Search Bar)
*/
router.get("/name-searchbar/:name", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      const names = [];

      for (let i = 0; i < filteredLenders.length; i++) {
        const el = filteredLenders[i];
        names.push(`${el.first_name} ${el.last_name}`);
      }

      res.json(names);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Name
*/
router.get("/email/:email", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      email: {
        [Op.substring]: req.params.email,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Name
*/
router.get("/name/:name", (req, res) => {
  console.log("Searching for lenders by name:", req.params.name.split(" ")[0]);

  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name.split(" ")[0],
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      console.log("Filtered lenders:", filteredLenders);
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Full Name
*/
router.get("/full-name/:name", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      full_name: req.params.name,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Name & City
*/
router.get("/city/:term/name/:name", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      const filtered = cityStartsWith(allLenders, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Full Name & City
*/
router.get("/city/:term/full-name/:name", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      areas_served: {
        [Op.substring]: req.params.term,
      },
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      full_name: req.params.name,
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      const filtered = cityStartsWith(allLenders, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Premium Lenders
*/
router.get("/busca/premium", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      isPremium: true,
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Recently Added Lenders
*/
router.get("/busca/recently-added", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
    },
    limit: 50,
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by City
*/
router.get("/busca/city/:term", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      const filtered = cityStartsWith(allLenders, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by City (Search Bar)
*/
router.get("/busca/city-searchbar/:term", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      const filtered = cityStartsWith(allLenders, req.params.term);

      res.json(filtered.uniqueCities);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Name (Search Bar)
*/
router.get("/busca/name-searchbar/:name", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      const names = [];

      for (let i = 0; i < filteredLenders.length; i++) {
        const el = filteredLenders[i];
        names.push(`${el.first_name} ${el.last_name}`);
      }

      res.json(names);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Name
*/
router.get("/busca/email/:email", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      email: {
        [Op.substring]: req.params.email,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Name
*/
router.get("/busca/name/:name", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Full Name
*/
router.get("/busca/full-name/:name", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      full_name: req.params.name,
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      // Filter through Users, do not return "deleted" users
      const filteredLenders = allLenders.filter(
        (Lender) => Lender.isDeleted !== true
      );
      res.json(filteredLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Name & City
*/
router.get("/busca/city/:term/name/:name", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      const filtered = cityStartsWith(allLenders, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Search Page - Search by Full Name & City
*/
router.get("/busca/city/:term/full-name/:name", (req, res) => {
  // Get all Lenders including its associated User and Student data
  Lender.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
      full_name: req.params.name,
    },
    order: [["id", "DESC"]],
  })
    .then((allLenders) => {
      const filtered = cityStartsWith(allLenders, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Lender Profile Page
*/
router.get("/:lender_id", (req, res) => {
  Lender.findOne({
    where: {
      id: req.params.lender_id,
      isDeleted: false,
    },
    include: [{ model: Uploads }],
  })
    .then((allLenders) => {
      res.json(allLenders);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Create Lender
*/
router.post("/", (req, res) => {
  /*
    expects:
      {
        first_name: STRING,
        last_name: STRING,
        phone_number: STRING,
        email: STRING,
        languages_spoken: STRING,
        primary_language: STRING,
        areas_served: STRING,
        brokerage: STRING,
        state_license_numbers: STRING,
        profile_description: STRING,
        image: STRING,
      },
  */
  req.body.full_name = `${req.body.first_name} ${req.body.last_name}`;

  Lender.create(req.body)
    .then((newLender) => {
      res.json({ newLender });
    })
    .catch((err) => {
      console.log(err);

      res.status(500).json(err);
    });
});

/*
  Edit Lender Profile Page
*/
router.put("/:id", (req, res) => {
  // update a Lender by its `id` value
  // expects {columnName: value}
  Lender.update(req.body, {
    where: {
      id: req.params.id,
    },
  })
    .then((udpatedLender) => {
      if (!udpatedLender[0]) {
        res
          .status(404)
          .json({ message: "There is no Lender found with this id" });
        return;
      }
      res.json(udpatedLender);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
   Super User Delete functionality
*/
// router.delete("/:id", (req, res) => {
//   // "Delete" a Lender by id - Update the boolean value to mark as "deleted"
//   // expects {id: INTEGER}
//   Lender.update(
//     { isDeleted: true },
//     {
//       where: {
//         id: req.params.id,
//       },
//     }
//   )
//     .then((deletedLender) => {
//       if (!deletedLender) {
//         res
//           .status(404)
//           .json({ message: "There are no Lenders found with this id" });
//         return;
//       }
//       res.json(deletedLender);
//     })
//     .catch((err) => {
//       console.log(err);
//       res.status(500).json(err);
//     });
// });
router.delete("/:id", async (req, res) => {
  try {
    // Find the lender by ID
    const lender = await Lender.findOne({
      where: {
        id: req.params.id,
      },
    });
    console.log("Lender found:", lender);

    if (!lender) {
      return res.status(404).json({ message: "No lender found with this ID." });
    }

    // Delete the lender
    await Lender.destroy({
      where: {
        id: req.params.id,
      },
    });

    await Notices.destroy({
      where: {
        agent_id: req.params.id,
      },
    });

    await User.destroy({
      where: {
        email: lender.email,
      },
    });

    res.json({ message: "Lender and associated user deleted successfully." });
  } catch (err) {
    console.error("Delete error:", err);
    res.status(500).json({ message: "Server error while deleting lender." });
  }
});

module.exports = router;
