const router = require("express").Router();
const { Notices } = require("../../models");

//The `/api/notices` endpoint

/*
  Currently Unused
*/
router.get("/", (req, res) => {
  // Get all Notices
  Notices.findAll({
    where: {
      isDeleted: false,
    },
  })
    .then((allNotices) => {
      res.json(allNotices);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Super User Dashboard
*/
router.get("/all", (req, res) => {
  Notices.findAll({
    where: {
      isDeleted: false,
      isDismissed: false,
    },
  })
    .then((allNotices) => {
      if (!allNotices) {
        res
          .status(404)
          .json({ message: "There are no Notices found with this id" });
        return;
      }
      res.json(allNotices);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Super User Dashboard
*/
router.get("/findahome", (req, res) => {
  Notices.findAll({
    where: {
      website: "Findahome",
      isDeleted: false,
      isDismissed: false,
    },
  })
    .then((allNotices) => {
      if (!allNotices) {
        res
          .status(404)
          .json({ message: "There are no Notices found with this id" });
        return;
      }
      res.json(allNotices);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Super User Dashboard
*/
router.get("/busca", (req, res) => {
  Notices.findAll({
    where: {
      website: "Busca",
      isDeleted: false,
      isDismissed: false,
    },
  })
    .then((allNotices) => {
      if (!allNotices) {
        res
          .status(404)
          .json({ message: "There are no Notices found with this id" });
        return;
      }
      res.json(allNotices);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Signup
*/
router.post("/", (req, res) => {
  /*
  Expects: {
    content: STRING,
    actions: STRING,
    actions_content: STRING
  }
  */
  Notices.create(req.body)
    .then((newNotice) => res.status(200).json(newNotice))
    .catch((err) => {
      console.log(err);
      res.status(400).json(err);
    });
});

/*
  Super User Dashboard
*/
router.post("/dismiss/:id", (req, res) => {
  // "Dismiss" a Notice by id - Update the boolean value to mark as "isDismissed:true"
  // expects {id: INTEGER}
  Notices.update(
    { isDismissed: true },
    {
      where: {
        id: req.params.id,
      },
    }
  )
    .then((dismissedNotice) => {
      if (!dismissedNotice) {
        res
          .status(404)
          .json({ message: "There are no Notices found with this id" });
        return;
      }
      res.json(dismissedNotice);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Super User Dashboard Page
*/
router.delete("/:id", (req, res) => {
  // "Delete" a Notice by id - Update the boolean value to mark as "deleted"
  // expects {id: INTEGER}
  Notices.update(
    { isDeleted: true },
    {
      where: {
        id: req.params.id,
      },
    }
  )
    .then((deletedNotice) => {
      if (!deletedNotice) {
        res
          .status(404)
          .json({ message: "There are no Notices found with this id" });
        return;
      }
      res.json(deletedNotice);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

module.exports = router;
