const express = require("express");
const fileUpload = require("express-fileupload");
const path = require("path");
const routes = require("./findahome.com/server/routes");
const sequelize = require("./findahome.com/server/config/connection");

// App setup
const app = express();
const PORT = process.env.PORT || 3001;

// App Middleware
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(fileUpload());
app.use(express.static("./findahome.com/uploads"));
app.use(express.static(path.join(__dirname, "./findahome.com/csvFiles")));
app.use(routes);

// *** Uncomment to serve the Ruuster React Application wildcard route ***
app.use(express.static("./findahome.com/client/ruuster/build/"));
app.get("*", (req, res) => {
  res.sendFile(
    path.resolve(__dirname, "./findahome.com/client/ruuster/build/index.html")
  );
});

// *** Uncomment to serve the IDX Broker React Application wildcard route ***
// app.use(express.static("../client/IDXBroker/build/"));
// app.get("*", (req, res) => {
//   res.sendFile(path.resolve(__dirname, "../findahome.com/client/IDXBroker/build/index.html"));
// });

// Connect Database and Server
// {force: false}: Database will not recreate tables if associations change
sequelize.sync({ force: false }).then(() => {
  app.listen(PORT, () => {
    console.log(`Server is running on PORT: ${PORT}`);
  });
});
