const { Model, DataTypes } = require("sequelize");

const sequelize = require("../config/connection.js");

class Lender extends Model {}

Lender.init(
  {
    // define columns
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    full_name: {
      type: DataTypes.STRING,
      allowNull: true,
      get() {
        const firstName = this.getDataValue("first_name");
        const lastName = this.getDataValue("last_name");
        return firstName && lastName ? `${firstName} ${lastName}` : null;
      },
    },
    first_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    last_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    phone_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    languages_spoken: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    primary_language: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: "English",
    },
    company: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    company_number: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: "",
    },
    areas_served: {
      type: DataTypes.STRING(1500),
      allowNull: true,
      defaultValue: "",
    },
    state_license_numbers: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    profile_description: {
      type: DataTypes.STRING(1500),
      allowNull: true,
    },
    image: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    isPremium: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    // Store a reference of user model's id
    user_id: {
      type: DataTypes.INTEGER,
      references: {
        model: "user",
        key: "id",
      },
    },
    isDeleted: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
  },
  {
    sequelize,
    timestamps: false,
    freezeTableName: true,
    underscored: true,
    modelName: "lender",
  }
);

module.exports = Lender;

// Primary Language selects which website the user will display on
// English - Findahome.com
// Spanish - Buscatucasa.com
// Both - will display on both sites
