const { Model, DataTypes } = require("sequelize");

const sequelize = require("../config/connection");
const { formatDate } = require("../utils/formatDate.js");

class Notices extends Model {}

Notices.init(
  {
    // define columns
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    // content
    content: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    // date
    date: {
      type: DataTypes.DATE,
      defaultValue: new Date(),
      allowNull: false,
      get() {
        return formatDate(this.getDataValue("date"));
      },
    },
    // actions
    actions: {
      type: DataTypes.STRING,
    },
    website: {
      type: DataTypes.STRING,
    },
    user_id: {
      type: DataTypes.INTEGER,
    },
    agent_id: {
      type: DataTypes.INTEGER,
    },
    // additional information for action in client
    actions_content: {
      type: DataTypes.STRING,
    },
    isDismissed: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    isDeleted: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
  },
  {
    sequelize,
    timestamps: false,
    freezeTableName: true,
    underscored: true,
    modelName: "Notices",
  }
);

module.exports = Notices;
