const router = require("express").Router();
const { Agent, Uploads } = require("../../models");
const { Op } = require("sequelize");
const { cityStartsWith } = require("../utils/agentHelpers");

// The `/api/agents` endpoint

/*
  Currently Unused
*/
router.get("/", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
    },
  })
    .then((allOficers) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allOficers.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Recently Added Agents
*/
router.get("/recently-added", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
    },
    limit: 50,
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Premium Agents
*/
router.get("/premium", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      isPremium: true,
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by City
*/
router.get("/city/:term", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      const filtered = cityStartsWith(allAgents, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by City (Search Bar)
*/
router.get("/city-searchbar/:term", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      const filtered = cityStartsWith(allAgents, req.params.term);

      res.json(filtered.uniqueCities);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Name (Search Bar)
*/
router.get("/name-searchbar/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      const names = [];

      for (let i = 0; i < filteredAgents.length; i++) {
        const el = filteredAgents[i];
        names.push(`${el.first_name} ${el.last_name}`);
      }

      res.json(names);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Name
*/
router.get("/email/:email", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      email: {
        [Op.substring]: req.params.email,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Name
*/
router.get("/name/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Full Name
*/
router.get("/full-name/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      full_name: req.params.name,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Name & City
*/
router.get("/city/:term/name/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      const filtered = cityStartsWith(allAgents, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Full Name & City
*/
router.get("/city/:term/full-name/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      areas_served: {
        [Op.substring]: req.params.term,
      },
      [Op.or]: [{ primary_language: "English" }, { primary_language: "Both" }],
      full_name: req.params.name,
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      const filtered = cityStartsWith(allAgents, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Premium Agents
*/
router.get("/busca/premium", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      isPremium: true,
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Recently Added Agents
*/
router.get("/busca/recently-added", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
    },
    limit: 50,
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by City
*/
router.get("/busca/city/:term", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      const filtered = cityStartsWith(allAgents, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by City (Search Bar)
*/
router.get("/busca/city-searchbar/:term", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      const filtered = cityStartsWith(allAgents, req.params.term);

      res.json(filtered.uniqueCities);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Name (Search Bar)
*/
router.get("/busca/name-searchbar/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      const names = [];

      for (let i = 0; i < filteredAgents.length; i++) {
        const el = filteredAgents[i];
        names.push(`${el.first_name} ${el.last_name}`);
      }

      res.json(names);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Name
*/
router.get("/busca/email/:email", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      email: {
        [Op.substring]: req.params.email,
      },
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Name
*/
router.get("/busca/name/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Full Name
*/
router.get("/busca/full-name/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      full_name: req.params.name,
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      // Filter through Users, do not return "deleted" users
      const filteredAgents = allAgents.filter(
        (Agent) => Agent.isDeleted !== true
      );
      res.json(filteredAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Name & City
*/
router.get("/busca/city/:term/name/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
      [Op.or]: [
        {
          first_name: {
            [Op.startsWith]: req.params.name,
          },
        },
        {
          last_name: {
            [Op.startsWith]: req.params.name,
          },
        },
      ],
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      const filtered = cityStartsWith(allAgents, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Search Page - Search by Full Name & City
*/
router.get("/busca/city/:term/full-name/:name", (req, res) => {
  // Get all Agents including its associated User and Student data
  Agent.findAll({
    where: {
      isDeleted: false,
      [Op.or]: [{ primary_language: "Spanish" }, { primary_language: "Both" }],
      areas_served: {
        [Op.substring]: req.params.term,
      },
      full_name: req.params.name,
    },
    order: [["id", "DESC"]],
  })
    .then((allAgents) => {
      const filtered = cityStartsWith(allAgents, req.params.term);

      res.json(filtered);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Agent Profile Page
*/
router.get("/:agent_id", (req, res) => {
  Agent.findOne({
    where: {
      id: req.params.agent_id,
      isDeleted: false,
    },
    include: [{ model: Uploads }],
  })
    .then((allAgents) => {
      res.json(allAgents);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Create Agent
*/
router.post("/", (req, res) => {
  /*
    expects:
      {
        first_name: STRING,
        last_name: STRING,
        phone_number: STRING,
        email: STRING,
        languages_spoken: STRING,
        primary_language: STRING,
        areas_served: STRING,
        brokerage: STRING,
        state_license_numbers: STRING,
        profile_description: STRING,
        image: STRING,
      },
  */
  req.body.full_name = `${req.body.first_name} ${req.body.last_name}`;

  Agent.create(req.body)
    .then((newAgent) => {
      res.json({ newAgent });
    })
    .catch((err) => {
      console.log(err);

      res.status(500).json(err);
    });
});

/*
  Edit Agent Profile Page
*/
router.put("/:id", (req, res) => {
  // update a Agent by its `id` value
  // expects {columnName: value}
  Agent.update(req.body, {
    where: {
      id: req.params.id,
    },
  })
    .then((udpatedAgent) => {
      if (!udpatedAgent[0]) {
        res
          .status(404)
          .json({ message: "There is no Agent found with this id" });
        return;
      }
      res.json(udpatedAgent);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
   Super User Delete functionality
*/
router.delete("/:id", (req, res) => {
  // "Delete" a Agent by id - Update the boolean value to mark as "deleted"
  // expects {id: INTEGER}
  Agent.update(
    { isDeleted: true },
    {
      where: {
        id: req.params.id,
      },
    }
  )
    .then((deletedAgent) => {
      if (!deletedAgent) {
        res
          .status(404)
          .json({ message: "There are no Agents found with this id" });
        return;
      }
      res.json(deletedAgent);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

module.exports = router;
