const router = require("express").Router();
const createCsvWriter = require("csv-writer").createObjectCsvWriter;
const { Agent, User, Lender } = require("../../models");
const { v4: uuidv4 } = require("uuid");
const fs = require("fs");
const path = require("path");

// The `/api/csv` endpoint

/*
  Download all Agents as CSV file
*/
router.get("/", (req, res) => {
  User.findAll({
    include: [{ model: Agent }],
    attributes: { exclude: ["password"] },
    required: false,
  })
    .then((allUsers) => {
      if (!allUsers) {
        res.status(404).json({ message: "No Users Found." });
        return;
      }

      // Name the file w/ today's date
      var today = new Date();
      var dd = String(today.getDate()).padStart(2, "0");
      var mm = String(today.getMonth() + 1).padStart(2, "0"); //January is 0!
      var yyyy = today.getFullYear();
      today = mm + "-" + dd + "-" + yyyy;

      const fileName = `${today}_Findahome-Agents_${uuidv4()}`;

      const csvWriter = createCsvWriter({
        path: path.resolve(__dirname, `../../../csvFiles/${fileName}.csv`),
        header: [
          { id: "user_id", title: "USER ID" },
          { id: "agent_id", title: "AGENT ID" },
          { id: "name", title: "NAME" },
          { id: "email", title: "EMAIL" },
          { id: "user_type", title: "USER TYPE" },
          { id: "phone_number", title: "PHONE NUMBER" },
          { id: "agent_email", title: "AGENT EMAIL" },
          { id: "languages_spoken", title: "LANGUAGES SPOKEN" },
          { id: "primary_language", title: "WEBSITE" },
          { id: "brokerage", title: "BROKERAGE NAME" },
          { id: "brokerage_number", title: "BROKERAGE PHONE NUMBER" },
          { id: "areas_served", title: "AREAS SERVED" },
          { id: "state_license_numbers", title: "STATE LICENSE NUMBERS" },
          { id: "profile_description", title: "PROFILE DESCRIPTION" },
          { id: "image", title: "IMAGE" },
          { id: "isPremium", title: "IS PREMIUM" },
        ],
      });

      // Add records to arr
      const records = [];

      const getWebsite = (language) => {
        switch (language) {
          case "English":
            return "Find a Home";
          case "Spanish":
            return "Busca Tu Casa";
          case "Both":
            return "Find a Home + Busca Tu Casa";
          default:
            return "Find a Home";
        }
      };

      for (let i = 0; i < allUsers.length; i++) {
        const user = allUsers[i];

        if (user.agents[0]) {
          const record = {
            user_id: user.id,
            agent_id: user.agents[0].id,
            name: `${user.agents[0].first_name} ${user.agents[0].last_name}`,
            email: user.email,
            user_type: user.user_type,
            phone_number: user.agents[0].phone_number,
            agent_email: user.agents[0].email,
            languages_spoken: user.agents[0].languages_spoken,
            primary_language: getWebsite(user.agents[0].primary_language),
            brokerage: user.agents[0].brokerage,
            brokerage_number: user.agents[0].brokerage_number,
            areas_served: user.agents[0].areas_served,
            state_license_numbers: user.agents[0].state_license_numbers,
            profile_description: user.agents[0].profile_description,
            image: user.agents[0].image,
            isPremium: user.agents[0].isPremium,
          };
          records.push(record);
        }
      }

      console.log(records);

      // Create the file
      csvWriter
        .writeRecords(records) // returns a promise
        .then(() => {
          console.log("...Done");
        });

      // Return the file name and user data
      res.json({ fileName: fileName });
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Download all Lenders as CSV file
*/
router.get("/lenders", (req, res) => {
  User.findAll({
    include: [{ model: Lender }],
    attributes: { exclude: ["password"] },
    required: false,
  })
    .then((allUsers) => {
      if (!allUsers) {
        res.status(404).json({ message: "No Users Found." });
        return;
      }

      // Name the file w/ today's date
      var today = new Date();
      var dd = String(today.getDate()).padStart(2, "0");
      var mm = String(today.getMonth() + 1).padStart(2, "0"); //January is 0!
      var yyyy = today.getFullYear();
      today = mm + "-" + dd + "-" + yyyy;

      const fileName = `${today}_Findahome-Lenders_${uuidv4()}`;

      const csvWriter = createCsvWriter({
        path: path.resolve(__dirname, `../../../csvFiles/${fileName}.csv`),
        header: [
          { id: "user_id", title: "USER ID" },
          { id: "lender_id", title: "LENDER ID" },
          { id: "name", title: "NAME" },
          { id: "email", title: "EMAIL" },
          { id: "user_type", title: "USER TYPE" },
          { id: "phone_number", title: "PHONE NUMBER" },
          { id: "lender_email", title: "LENDER EMAIL" },
          { id: "languages_spoken", title: "LANGUAGES SPOKEN" },
          { id: "primary_language", title: "WEBSITE" },
          { id: "company", title: "COMPANY NAME" },
          { id: "company_number", title: "COMPANY PHONE NUMBER" },
          { id: "areas_served", title: "AREAS SERVED" },
          { id: "state_license_numbers", title: "STATE LICENSE NUMBERS" },
          { id: "profile_description", title: "PROFILE DESCRIPTION" },
          { id: "image", title: "IMAGE" },
          { id: "isPremium", title: "IS PREMIUM" },
        ],
      });

      // Add records to arr
      const records = [];

      const getWebsite = (language) => {
        switch (language) {
          case "English":
            return "Find a Home";
          case "Spanish":
            return "Busca Tu Casa";
          case "Both":
            return "Find a Home + Busca Tu Casa";
          default:
            return "Find a Home";
        }
      };

      for (let i = 0; i < allUsers.length; i++) {
        const user = allUsers[i];

        if (user.lenders[0]) {
          const record = {
            user_id: user.id,
            lender_id: user.lenders[0].id,
            name: `${user.lenders[0].first_name} ${user.lenders[0].last_name}`,
            email: user.email,
            user_type: user.user_type,
            phone_number: user.lenders[0].phone_number,
            lender_email: user.lenders[0].email,
            languages_spoken: user.lenders[0].languages_spoken,
            primary_language: getWebsite(user.lenders[0].primary_language),
            company: user.lenders[0].company,
            company_number: user.lenders[0].company_number,
            areas_served: user.lenders[0].areas_served,
            state_license_numbers: user.lenders[0].state_license_numbers,
            profile_description: user.lenders[0].profile_description,
            image: user.lenders[0].image,
            isPremium: user.lenders[0].isPremium,
          };
          records.push(record);
        }
      }

      console.log(records);

      // Create the file
      csvWriter
        .writeRecords(records) // returns a promise
        .then(() => {
          console.log("...Done");
        });

      // Return the file name and user data
      res.json({ fileName: fileName });
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

module.exports = router;
