const router = require("express").Router();
const AppError = require("../../utils/appError");
const nodemailer = require("nodemailer");

// Welcome Email
router.post("/send-welcome-email", async (req, res, next) => {
  if (!req.body || !req.body.email) {
    return next(new AppError("Email address is required", 400));
  }

  try {
    // set up nodemailer transporter
    const transporter = nodemailer.createTransport({
      service: "gmail",
      port: 465,
      auth: {
        user: "help@brainjar.net",
        pass: "tufrvbirflaoiznu",
      },
    });

    console.log("using Port 465");

    // mail options
    const mailOptions = {
      from: "help@brainjar.net",
      to: req.body.email,
      subject: "Welcome Findahome Agent!",
      //we can style this
      text: `Welcome to the Findahome Agent network! We're happy to have you.`,
    };

    // send email
    transporter.sendMail(mailOptions, (error, info) => {
      if (error) {
        return next(
          new AppError(
            "Error sending email from Findahome.com on port 465: " +
              error.message,
            500
          )
        );
      } else {
        res.json({
          message: "Your welcome email has been sent to the email address.",
        });
      }
    });
  } catch (err) {
    console.error("Error:", err);
    return next(new AppError("Server error: " + err.message, 500));
  }
});

// Confirmation Email (To Jason)
router.post("/send-confirmation-email", async (req, res, next) => {
  try {
    // set up nodemailer transporter
    const transporter = nodemailer.createTransport({
      service: "gmail",
      auth: {
        user: "help@brainjar.net",
        pass: "tufrvbirflaoiznu",
      },
    });

    // mail options
    const mailOptions = {
      from: "help@brainjar.net",
      to: "santiago@findahomeintn.com",
      subject: "New Agent Signup",
      //we can style this
      text: `A new Find a Home Agent has signed up!`,
    };

    // send email
    transporter.sendMail(mailOptions, (error, info) => {
      if (error) {
        return next(new AppError("Error sending email: " + error.message, 500));
      } else {
        res.json({
          message: "Your confirmation email has been sent.",
        });
      }
    });
  } catch (err) {
    console.error("Error:", err);
    return next(new AppError("Server error: " + err.message, 500));
  }
});

module.exports = router;
