const router = require("express").Router();
const path = require("path");
const { existsSync } = require("fs");
const { v4: uuidv4 } = require("uuid");
const { Uploads, Agent } = require("../../models");

//The `/api/uploads` endpoint

/*
  Currently Unused
*/
router.get("/", (req, res) => {
  Uploads.findAll({
    include: [
      {
        model: Agent,
      },
    ],
  })
    .then((allUploads) => {
      res.json(allUploads);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

/*
  Edit Agent Profile Page
*/
router.post("/create", (req, res) => {
  /*
    Add the file to the uploads folder
    expects: req.files[FormData()]
    returns: file name (JSON)
  */

  // Check that there is a file to upload
  if (req.files === null) {
    return res.status(400).json({ message: "No file submitted for upload!" });
  }

  console.log(req.files);

  const file = req.files.file;
  let originalFileName = file.name;
  let fileExtension = path.extname(originalFileName);
  let fileNameWithoutExtension = path.basename(originalFileName, fileExtension);

  // Generate the new file name with UUID to prevent overwrites
  let fileName = `${uuidv4()}-${fileNameWithoutExtension}${fileExtension}`;
  let newFilePath = path.join(__dirname, "../../../uploads", fileName);

  // If a file with the new file name already exists, add a number suffix
  let count = 1;
  while (existsSync(newFilePath)) {
    fileName = `${uuidv4()}-${fileNameWithoutExtension}-${count}${fileExtension}`;
    newFilePath = path.join(__dirname, "../../../uploads", fileName);
    count++;
  }

  // Add the file to the uploads folder
  file.mv(`${newFilePath}`, (err) => {
    if (err) {
      console.log(err);
      return res.status(500).send(err);
    }
    res.status(200).json({
      message: "File successfully uploaded!",
      fileName: fileName,
      displayName: fileNameWithoutExtension,
    });
  });
});

/*
  Edit Agent Profile Page/Agent Signup
*/
router.post("/", (req, res) => {
  // Create new Upload
  /*
    expects:
      {
        location: STRING,
        display_name: STRING,
        type: STRING,
        date: STRING,
        agent_id: INT,
      }
*/
  Uploads.create(req.body)
    .then((newUpload) => res.status(200).json(newUpload))
    .catch((err) => {
      console.log(err);
      res.status(400).json(err);
    });
});

/*
  Currently Unused
*/
router.delete("/:id", (req, res) => {
  // "Delete" an Upload by id - Update the boolean value to mark as "deleted"
  // expects {id: INTEGER}
  Uploads.update(
    { isDeleted: true },
    {
      where: {
        id: req.params.id,
      },
    }
  )
    .then((deletedUpload) => {
      if (!deletedUpload) {
        res
          .status(404)
          .json({ message: "There are no Uploads found with this id" });
        return;
      }
      res.json(deletedUpload);
    })
    .catch((err) => {
      console.log(err);
      res.status(500).json(err);
    });
});

module.exports = router;
