const cityStartsWith = (allAgents, term) => {
  term = term.toLowerCase();
  const cityNames = [];

  const checkStartsWith = (areas, term) => {
    const areaArr = areas.split("; ");
    const filtered = [];

    if (areaArr[1]) {
      // Agent serves more than one area
      for (let i = 0; i < areaArr.length; i++) {
        let el = areaArr[i];
        const lowercase = el.toLowerCase();
        const startsWith = lowercase.startsWith(term);
        if (startsWith === true) {
          filtered.push(el);
          cityNames.push(el);
        }
      }
      return filtered.length !== 0 ? true : false;
    } else {
      // Agent serves one area
      const lowercase = areas.toLowerCase();
      const startsWith = lowercase.startsWith(term);

      if (startsWith === true) {
        cityNames.push(areas);
        return true;
      } else {
        return false;
      }
    }
  };

  const filteredAgents = allAgents.filter((Agent) => Agent.isDeleted !== true);

  const filterCities = filteredAgents.filter(
    (Agent) => checkStartsWith(Agent.areas_served, term) === true
  );

  const uniqueCities = [...new Set(cityNames)];

  return { filterCities, uniqueCities };
};

module.exports = { cityStartsWith };
