/*
Expects: date obj
Returns: mm/dd/yyyy
*/
const formatDate = (date) => {
  if (date === undefined || date === null) {
    // If the date is undefined (UPDATE requests)
    // Or if the date is null (i.e. birthdays are allowed null)
    return;
  } else {
    // Return formatted date w/ GET routes
    const month = ("0" + (date.getMonth() + 1)).slice(-2);
    const day = ("0" + date.getDate()).slice(-2);
    const year = date.getFullYear();
    return `${month}/${day}/${year}`;
  }
};

module.exports = { formatDate };
